import re

def validate_name(name):
	"""Check if the name is properly formatted
	Must be in kebab-case, with possible underscore for prefixes/sufixes
	and only alphanumerical
	A-z0-9 doesn’t seem to work in regexp, so had to write them full extent
	"""

	allowed = re.match(r'^([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789]+)_?([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-]+)_?([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789]+)$', name)
	return allowed is not None