import bpy

from ..operators import readthedocs, export2godot
from ..common import icons


class GB_PT_panel_main(bpy.types.Panel):
    """
    Main panel in 3D View
    """

    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_category = 'Godot bridge'


class GB_PT_panel_header(GB_PT_panel_main):
    """
    Header of the panel
    """
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_category = 'Godot bridge'
    bl_label = 'Godot bridge'

    def draw_header(self, context):
        layout = self.layout
        layout.label(icon_value=icons.get_icon_id("godot_bridge"))

    def draw(self, context):
        layout = self.layout

        row = layout.row()
        row.operator(export2godot.GB_OT_export2godot.bl_idname, icon_value=icons.get_icon_id("godot"))
        layout.separator()

class GB_PT_panel_parameters(GB_PT_panel_main):
    """
    Sub panel for parameters
    """
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_category = 'Godot bridge'
    bl_parent_id = "GB_PT_panel_header"
    bl_label = 'Parameters'


    def draw_header(self, context):
        layout = self.layout

    def draw(self, context):
        layout = self.layout

        layout.separator()
        row = layout.row()
        row.prop(bpy.context.scene, "godot_project_path")
        row = layout.row()
        row.prop(bpy.context.scene, "blender_repository_path")
        row = layout.row()
        row.prop(bpy.context.scene, "root_collection")
        row = layout.row()
        row.prop(bpy.context.scene, "licence")
        row = layout.row()
        row.prop(bpy.context.scene, "contributor")

class GB_PT_panel_docs(GB_PT_panel_main):

    """
    Sub panel for documentation & links
    """
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_category = 'Godot bridge'
    bl_label = 'Documentation'
    bl_parent_id = "GB_PT_panel_header"


    def draw_header(self, context):
        layout = self.layout

    def draw(self, context):
        layout = self.layout    
        row = layout.row()
        row.operator(readthedocs.GB_OT_readthedocs.bl_idname, icon_value=72)
        layout.separator()
