import bpy

from .sidecar import GB_sidecar

""" PARAMS = [
    ('godot_project_path', bpy.props.StringProperty(name="Godot project path", subtype='DIR_PATH', default=prefs.default_godot_project_path )),
    ('blender_repository_path', bpy.props.StringProperty(name="Blender repository root", subtype='DIR_PATH', default=prefs.default_blender_repository_path)),
    ('root_collection', bpy.props.StringProperty(name="Root collection", default=prefs.default_root_collection)),
    ('licence', bpy.props.StringProperty(name="Licence", default=prefs.default_licence)),
    ('contributor', bpy.props.StringProperty(name="Contributor", default=prefs.default_contributor)),
] """

PARAMS = [
    ('godot_project_path', bpy.props.StringProperty(name="Godot project path", subtype='DIR_PATH', default="" )),
    ('blender_repository_path', bpy.props.StringProperty(name="Blender repository root", subtype='DIR_PATH', default="")),
    ('root_collection', bpy.props.StringProperty(name="Root collection", default="")),
    ('licence', bpy.props.StringProperty(name="Licence", default="")),
    ('contributor', bpy.props.StringProperty(name="Contributor", default="")),
]

classes = (
    GB_sidecar,
)

def register_parameters():
    for (param_name, param_value) in PARAMS:
        setattr(bpy.types.Scene, param_name, param_value)
    from bpy.utils import register_class
    for cls in classes:
        register_class(cls)
    

def unregister_parameters():
    for (param_name, _) in PARAMS:
        delattr(bpy.types.Scene, param_name)
    from bpy.utils import unregister_class
    for cls in classes:
        unregister_class(cls)