import bpy

from .preferences  import GODOT_BRIDGE_preferences

_classes = (
    GODOT_BRIDGE_preferences,
)

def register_preferences():
    from bpy.utils import register_class
    for cls in _classes:
        print("Registering {}".format(cls))
        register_class(cls)
    

def unregister_preferences():
    from bpy.utils import unregister_class
    for cls in _classes:
        unregister_class(cls)