import bpy
from bpy.props import StringProperty, IntProperty, BoolProperty

from .. import __package__ as base_package

class GODOT_BRIDGE_preferences(bpy.types.AddonPreferences):
	bl_idname = base_package

	# TODO  EnumProperty to get list of projects to choose from

	default_godot_project_path: StringProperty(
		name="Godot project path",
		subtype='DIR_PATH',
		default="//godot_project/"
	)

	default_blender_repository_path: StringProperty(
		name="Blender repository root",
		subtype='DIR_PATH',
		default="//"
	)

	default_root_collection: StringProperty(
		name="Root collection",
		default="khanat",
	)

	default_licence: StringProperty(
		name="Licence",
		default="CC BY SA Khaganat",
	)

	default_contributor: StringProperty(
		name="Contributor",
		default="",
	)

	def draw(self, context):
		print("DEF DRAW")
		layout = self.layout

		box = layout.box()
		box.label(text="Project Settings")
		box.prop(self, "default_godot_project_path")
		box.prop(self, "default_blender_repository_path")
		box.prop(self, "default_root_collection")

		box = layout.box()
		ox.label(text="Metadata")
		box.prop(self, "default_licence")
		box.prop(self, "default_contributor")

